/*
 * 
 
 * NodeMCU ESP32-S si 3 servo pe D12,13, 14
 * 
 * genereaza AP server ESP32S Servo
 * passw 12345678
 * 

*/

#include "esp_wifi.h"
#include "esp_camera.h"
#include <WiFi.h>

#include "Arduino.h"  
const char* ssid = "ESP32S Servo";
const char* password = "12345678";

WiFiServer server(80);

#include "soc/soc.h"
#include "soc/rtc_cntl_reg.h"

void startServer();   

const int ServoPin1 = 12;   //servo pe pin 12 merge
const int ServoPin2 = 13;   //servo pe pin 13 merge 
const int ServoPin3 = 14;   //servo pe pin 4 merge

void initServo() 
  {
  ledcSetup(8, 50, 16); 
  // 50 hz PWM, 16-bit resolution, range from 3250 to 6500.
  ledcAttachPin(ServoPin1, 8); 
  //8 este indexul variabilei ledc pentru acest sero
  
  //adaug inca un servo pe pin 12, servo2, cu indexul 9
  ledcSetup(9, 50, 16); // 50 hz PWM, 16-bit resolution, range from 3250 to 6500.
  ledcAttachPin(ServoPin2, 9); 

  ledcSetup(10, 50, 16); // 50 hz PWM, 16-bit resolution, range from 3250 to 6500.
  ledcAttachPin(ServoPin3, 10);  //servo3 pe pin 14
  //10 este indexul variabilei ledc 
        }

void setup() 
{
  WRITE_PERI_REG(RTC_CNTL_BROWN_OUT_REG, 0); // prevent brownouts by silencing them
  
  Serial.begin(115200);
  Serial.setDebugOutput(true);
  Serial.println();


  initServo();    //activare servos
  

WiFi.softAP(ssid, password);
  IPAddress miIP = WiFi.softAPIP();
  Serial.print("AP IP address: ");
  Serial.println(miIP); 

startServer(); 
}
 
void loop() {
  
  delay(1000);
  //Serial.printf("RSSi: %ld dBm\n",WiFi.RSSI()); 
}
